//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include <math.h>
#include "fftmain.h"
#include "ViewUnit.h"
//---------------------------------------------------------------------------
#pragma resource "*.dfm"
TViewForm *ViewForm;
//---------------------------------------------------------------------------
__fastcall TViewForm::TViewForm(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TViewForm::SigPBPaint(TObject *Sender)
{
long i;
long hh;
long width;

   // clear old data
   // Paint the Signal Window
   hh=SigPB->Height/2;
   width=SigPB->Width;
   // Draw zero line
   SigPB->Canvas->Pen->Color=clBlack;
   SigPB->Canvas->Pen->Width=1;
   SigPB->Canvas->MoveTo(0,hh);
   SigPB->Canvas->LineTo(width,hh);

   // Draw the actual signal
   SigPB->Canvas->Pen->Color=clBlue;
   if (sig!=NULL)
   {
      SigPB->Canvas->MoveTo(0,hh-sig[0]);
      for (i=1;i<num_samps;i++)
        SigPB->Canvas->LineTo(i,hh-sig[i*2]);

   }


}
//---------------------------------------------------------------------------
void __fastcall TViewForm::FFTPBMouseMove(TObject *Sender, TShiftState Shift,
    int X, int Y)
{
   BinLbl->Caption=IntToStr(X);
   FreqLbl->Caption=FloatToStrF(X*bin_width,ffFixed,3,2);
}
//---------------------------------------------------------------------------
void __fastcall TViewForm::FFTPBPaint(TObject *Sender)
{
long i;
long hh;
long width;

   // Paint the fft window
   hh=FFTPB->Height/2;
   width=FFTPB->Width;
   // Draw zero line
   FFTPB->Canvas->Pen->Color=clBlack;
   FFTPB->Canvas->Pen->Width=1;
   FFTPB->Canvas->MoveTo(0,hh);
   FFTPB->Canvas->LineTo(width,hh);

   // Draw the actual signal
   FFTPB->Canvas->Pen->Color=clBlue;
   if (fftreal!=NULL)
   {
      FFTPB->Canvas->MoveTo(0,hh-100.0*fabs(fftreal[0]));
      for (i=1;i<fsize/2;i++)
        FFTPB->Canvas->LineTo(i,hh-100.0*fabs(fftreal[i]));

   }


}
//---------------------------------------------------------------------------
void __fastcall TViewForm::FormPaint(TObject *Sender)
{
    SigPB->Invalidate();
    FFTPB->Invalidate();
}
//---------------------------------------------------------------------------
